<?php if ( ! defined( 'ABSPATH' ) ) { die; } // Cannot access pages directly.
/**
*
* Theme: 	simple
*
* @since 1.0.0
* @version 1.0.1
*
*/

class Uwac_widget_theme_simple{
	public function __construct(){
		$this->theme_name   = 'simple';
		$this->theme_prefix = 'uwac_theme-'.$this->theme_name;
	}
	
	public function get_settings(){
		$theme_id 		= $this->theme_prefix;
		$theme_prefix 	= $theme_id .'__';
		$styles_path 	= CS_UWAC_PLUGIN_URI .'/themes/widget/'.$this->theme_name;
		
		$settings 		= array(
			'dependency'	=> array('floatingwidget_theme_'.$this->theme_name,'==','true'),
			'id'			=> $theme_id,
			'type'			=> 'fieldset',
			'fields'		=> array(
				array(
					'type'			=> 'subheading',
					'content'		=> __('Simple Theme - Settings','uwac'),
				),
				array(
					'id'            => $theme_prefix.'style',
					'type'          => 'select',
					'title'         => __('Style','uwac'),
					'options'		=> array(
						'light'		=> __('Light','uwac'),
						'dark'		=> __('Dark','uwac'),
						'custom'	=> __('Custom','uwac'),
					),
					'default'		=> 'light',
				),
				array(
					'dependency'	=> array($theme_prefix.'style','==','custom'),
					'id'			=> $theme_prefix.'colors',
					'type'			=> 'container',
					'fields'		=> array(
						array(
							'id'        => $theme_prefix.'button_colors',
							'type'      => 'color_group',
							'title'     => __('Button Colors','uwac'),
							'settings'	=> array(
								'width_style'	=> 'inline', // block - inline
							),
							'options'	=> array(
								array(
									'type'	=> 'group',
									'title'	=> __('Button Colors','uwac'),
									'colors'	=> array(
										'color-button-bg' 	=> __('Background','uwac'),
										'color-button-text' => __('Icon','uwac'),
									),
								),
								array(
									'type'	=> 'group',
									'title'	=> __('Button Label','uwac'),
									'colors'	=> array(
										'color-label-bg' 	=> __('Background','uwac'),
										'color-label-text' 	=> __('Text','uwac'),
									),
								),
							),
							'default'   => array(
								'color-button-bg' 	=> '#2db742',
								'color-button-text' => '#ffffff',
								'color-label-bg' 	=> '#f5f7f9',
								'color-label-text' 	=> '#43475e',
							),
						),
						array(
							'id'        => $theme_prefix.'popup_colors',
							'type'      => 'color_group',
							'title'     => __('Popup Window Colors','uwac'),
							'settings'	=> array(
								'width_style'	=> 'inline', // block - inline
							),
							'options'	=> array(
								array(
									'type'	=> 'group',
									'title'	=> __('Header Colors','uwac'),
									'colors'	=> array(
										'color-header-bg' 			=> __('Background','uwac'),
										'color-header-icon'			=> __('Icon','uwac'),
										'color-header-text-title' 	=> __('Title Text','uwac'),
										'color-header-text-desc' 	=> __('Description Text','uwac'),
									),
								),
								array(
									'type'	=> 'group',
									'title'	=> __('Content Colors','uwac'),
									'colors'	=> array(
										'color-content-bg' 		=> __('Background','uwac'),
										'color-content-text' 	=> __('Text','uwac'),
									),
								),
								array(
									'type'	=> 'group',
									'title'	=> __('Account Item Colors','uwac'),
									'colors'	=> array(
										'color-item-bg' 			=> __('Normal Background','uwac'),
										'color-item-text' 			=> __('Normal Text','uwac'),
										'color-item-hover-bg' 		=> __('Hover Background','uwac'),
										'color-item-hover-text' 	=> __('Hover Text','uwac'),
									),
								),
							),
							'default'   => array(
								'color-header-bg' 			=> '#2db742',
								'color-header-icon'			=> 'rgba(255,255,255,0.95)',
								'color-header-text-title' 	=> 'rgba(255,255,255,0.95)',
								'color-header-text-desc' 	=> 'rgba(255,255,255,0.85)',
								'color-content-bg' 			=> '#ffffff',
								'color-content-text' 		=> '#a5abb7',
								'color-item-bg' 			=> '#f5f7f9',
								'color-item-text' 			=> '#43475e',
								'color-item-hover-bg' 		=> '#ffffff',
								'color-item-hover-text' 	=> '#56565e',
							),
						),
					),
				),
				
				
				
				
				array(
					'id'            => $theme_prefix.'position',
					'type'          => 'select',
					'title'         => __('Widget Position','uwac'),
					'options'		=> array(
						// 'topleft'		=> __('Top Left','uwac'),
						// 'topright'		=> __('Top Right','uwac'),
						'bottomleft'	=> __('Bottom Left','uwac'),
						'bottomright'	=> __('Bottom Right','uwac'),
					),
					'default'		=> 'bottomright',
					'columns' 		=> '6',
				),
				array(
					'id'			=> $theme_prefix.'widget_position',
					'type'			=> 'container',
					'label_type'	=> 'top',
					'columns' 		=> '6',
					'fields'		=> array(
						array(
							'dependency'	=> array($theme_prefix.'position','==','topleft'),
							'id'			=> $theme_prefix.'position_topleft',
							'type'			=> 'spacing',
							'settings' 		=> array(
								'all'		=> false,
								'right'		=> false,
								'bottom'	=> false,
								'unit'		=> false,
							),
							'default'		=> array(
								'top'		=> '20',
								'left'		=> '20',
								'unit'		=> 'px',
							),
						),
						array(
							'dependency'	=> array($theme_prefix.'position','==','topright'),
							'id'			=> $theme_prefix.'position_topright',
							'type'			=> 'spacing',
							'settings' 		=> array(
								'all'		=> false,
								'left'		=> false,
								'bottom'	=> false,
								'unit'		=> false,
							),
							'default'		=> array(
								'top'		=> '20',
								'right'		=> '20',
								'unit'		=> 'px',
							),
						),
						array(
							'dependency'	=> array($theme_prefix.'position','==','bottomleft'),
							'id'			=> $theme_prefix.'position_bottomleft',
							'type'			=> 'spacing',
							'settings' 		=> array(
								'all'		=> false,
								'right'		=> false,
								'top'		=> false,
								'unit'		=> false,
							),
							'default'		=> array(
								'bottom'	=> '20',
								'left'		=> '20',
								'unit'		=> 'px',
							),
						),
						array(
							'dependency'	=> array($theme_prefix.'position','==','bottomright'),
							'id'			=> $theme_prefix.'position_bottomright',
							'type'			=> 'spacing',
							'settings' 		=> array(
								'all'		=> false,
								'left'		=> false,
								'top'		=> false,
								'unit'		=> false,
							),
							'default'		=> array(
								'bottom'	=> '20',
								'right'		=> '20',
								'unit'		=> 'px',
							),
						),
					),
				),
			),
		);
		return $settings;
	}
	
	public function parse_settings($settings){
		$option = function($option) use ($settings){
			$theme_prefix = $this->theme_prefix.'__';
			return $settings[$theme_prefix.$option];
		};
		$_prefix = $this->theme_prefix.'__';
		
		
		// Parse Settings
		// ==========================================================================
		// $_c = new Colors();
		
		
		// Theme
		$style = $option('style');
		if ($style == 'light' || $style == 'dark'){
			if ($style == 'light'){
				$scheme = array(
					'color-button-bg' 			=> '#2db742',
					'color-button-text' 		=> '#ffffff',
					'color-label-bg' 			=> '#f5f7f9',
					'color-label-text' 			=> '#43475e',
					'color-header-bg' 			=> '#2db742',
					'color-header-icon'			=> 'rgba(255,255,255,0.95)',
					'color-header-text-title' 	=> 'rgba(255,255,255,0.95)',
					'color-header-text-desc' 	=> 'rgba(255,255,255,0.85)',
					'color-content-bg' 			=> '#ffffff',
					'color-content-text' 		=> '#a5abb7',
					'color-item-bg' 			=> '#f5f7f9',
					'color-item-text' 			=> '#43475e',
					'color-item-hover-bg' 		=> '#ffffff',
					'color-item-hover-text' 	=> '#56565e',
				);
			} else if ($style == 'dark'){
				$scheme = array(
					"color-button-bg" 			=> "#2db742",
					"color-button-text" 		=> "#ffffff",
					"color-label-bg"			=> "rgb(63, 66, 72)",
					"color-label-text" 			=> "rgb(169, 169, 169)",
					"color-header-bg" 			=> "rgb(48, 51, 56)",
					'color-header-icon'			=> "rgba(255,255,255,0.45)",
					"color-header-text-title" 	=> "rgba(255,255,255,0.45)",
					"color-header-text-desc" 	=> "rgba(255,255,255,0.3)",
					"color-content-bg" 			=> "rgb(63, 66, 72)",
					"color-content-text" 		=> "#a5abb7",
					"color-item-bg" 			=> "rgb(53, 56, 62)",
					"color-item-text" 			=> "rgb(104, 105, 105)",
					"color-item-hover-bg" 		=> "rgb(48, 51, 56)",
					"color-item-hover-text" 	=> "rgba(255,255,255,0.4)",
				);
			}
			// Button
			$button_bg 			= $scheme['color-button-bg'];
			$button_text 		= $scheme['color-button-text'];
			$label_bg 			= $scheme['color-label-bg'];
			$label_text 		= $scheme['color-label-text'];
			
			// Popup
			$header_bg 			= $scheme['color-header-bg'];
			$header_icon 		= $scheme['color-header-icon'];
			$header_text_title 	= $scheme['color-header-text-title'];
			$header_text_desc 	= $scheme['color-header-text-desc'];
			$content_bg 		= $scheme['color-content-bg'];
			$content_text 		= $scheme['color-content-text'];
			$item_bg			= $scheme['color-item-bg'];
			$item_text			= $scheme['color-item-text'];
			$item_hover_bg		= $scheme['color-item-hover-bg'];
			$item_hover_text	= $scheme['color-item-hover-text'];
		} else if ($style == 'custom'){
			$c = $option('colors');
			$b = $c[$_prefix.'button_colors'];
			$p = $c[$_prefix.'popup_colors'];

			// Button
			$button_bg 		= $b['color-button-bg'];
			$button_text 	= $b['color-button-text'];
			$label_bg 		= $b['color-label-bg'];
			$label_text 	= $b['color-label-text'];
			
			// Popup
			$header_bg 			= $p['color-header-bg'];
			$header_icon 		= $p['color-header-icon'];
			$header_text_title 	= $p['color-header-text-title'];
			$header_text_desc 	= $p['color-header-text-desc'];
			$content_bg 		= $p['color-content-bg'];
			$content_text 		= $p['color-content-text'];
			$item_bg			= $p['color-item-bg'];
			$item_text			= $p['color-item-text'];
			$item_hover_bg		= $p['color-item-hover-bg'];
			$item_hover_text	= $p['color-item-hover-text'];
		}
		

		// Position
		$position 		= $option('position');
		$w_position 	= $option('widget_position');
		$position_value = $w_position["{$_prefix}position_{$position}"];
		$pos_top 	= (isset($position_value['top'])) ? $position_value['top'] .'px' : 'initial';
		$pos_right 	= (isset($position_value['right'])) ? $position_value['right'] .'px' : 'initial';
		$pos_bottom = (isset($position_value['bottom'])) ? $position_value['bottom'] .'px' : 'initial';
		$pos_left 	= (isset($position_value['left'])) ? $position_value['left'] .'px' : 'initial';

		// if ($position == 'topleft'){
		// 	$pos_top 	= $position_value['top'];
		// 	$pos_right 	= $position_value['right'];
		// 	$pos_bottom = $position_value['bottom'];
		// 	$pos_left 	= $position_value['left'];
		// } else if ($position == 'topright'){
		// 	$pos_top 	= $position_value['top'];
		// 	$pos_right 	= $position_value['right'];
		// 	$pos_bottom = $position_value['bottom'];
		// 	$pos_left 	= $position_value['left'];
		// } else if ($position == 'bottomleft'){

		// } else if ($position == 'bottomright'){

		// }


		
		// Output Theme CSS Vars
		// ==========================================================================
		$output = "
			%s_button-bg:					$button_bg;
			%s_button-text: 				$button_text;
			%s_label-bg:					$label_bg;
			%s_label-text: 					$label_text;

			%s_header-bg:					$header_bg;
			%s_header-icon:					$header_icon;
			%s_header-text-title: 			$header_text_title;
			%s_header-text-desc: 			$header_text_desc;
			%s_content-bg:					$content_bg;
			%s_content-text: 				$content_text;
			%s_item-bg:						$item_bg;
			%s_item-text: 					$item_text;
			%s_item-hover-bg:				$item_hover_bg;
			%s_item-hover-text: 			$item_hover_text;

			%s_position-top:				$pos_top;
			%s_position-right:				$pos_right;
			%s_position-bottom:				$pos_bottom;
			%s_position-left:				$pos_left;
		";
		$prefix = CS_UWAC_CSS_THEME_SLUG;
		$output = str_replace('%s',$prefix,$output);
		return $output;
	}
}